/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.api.tree;

import com.google.common.base.Preconditions;
import com.lintyservices.sonar.plugins.tcl.api.TclFileScannerContext;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.visitors.TreeVisitor;
import java.util.Set;

public abstract class SubscriptionVisitor
implements TreeVisitor {
    private TclFileScannerContext context;

    public abstract Set<TclTree.Kind> nodesToVisit();

    public void visitNode(TclTree tree) {
    }

    public void leaveNode(TclTree tree) {
    }

    public void visitFile(TclTree tree) {
    }

    public void leaveFile(TclTree tree) {
    }

    @Override
    public void scanTree(TclFileScannerContext context) {
        this.context = context;
        this.visitFile(context.getTree());
        this.scanTree(context.getTree());
        this.leaveFile(context.getTree());
    }

    public void scanTree(TclTree tree) {
        this.visit(tree);
    }

    private void visit(TclTree tree) {
        boolean isSubscribed = this.isSubscribed(tree);
        if (isSubscribed) {
            this.visitNode(tree);
        }
        this.visitChildren(tree);
        if (isSubscribed) {
            this.leaveNode(tree);
        }
    }

    private boolean isSubscribed(TclTree tree) {
        return this.nodesToVisit().contains(tree.kind());
    }

    private void visitChildren(TclTree tree) {
        TreeImpl treeImpl = (TreeImpl)tree;
        if (!treeImpl.isLeaf()) {
            for (TclTree next : treeImpl.getChildren()) {
                if (next == null) continue;
                this.visit(next);
            }
        }
    }

    @Override
    public TclFileScannerContext getContext() {
        Preconditions.checkState(this.context != null, "this#scanTree(context) should be called to initialised the context before accessing it");
        return this.context;
    }
}

