/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.utils.LintyException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="TCL006")
public class EndLineCharactersCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor {
    private static final String DEFAULT_FORMAT = "LF";
    @RuleProperty(key="endLineCharacter", description="Allowed values: 'CR', 'CRLF', 'LF'", defaultValue="LF")
    public String endLineCharacter = "LF";
    private Charset charset;

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        if (this.fileContainsIllegalEndLineCharacters()) {
            this.addFileIssue("Set all end-line characters to '" + this.endLineCharacter + "' on this file.");
        }
        super.visitScriptFile(tree);
    }

    @Override
    public void validateCheckParameters() {
        if (!Arrays.asList("CRLF", "CR", DEFAULT_FORMAT).contains(this.endLineCharacter)) {
            throw new LintyException("endLineCharacter parameter is not valid.\nActual: '" + this.endLineCharacter + "'\nExpected: 'CR' or 'CRLF' or 'LF'");
        }
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    private boolean fileContainsIllegalEndLineCharacters() {
        try {
            String fileContent = Files.asCharSource(this.getContext().getFile(), this.charset).read();
            return "CR".equals(this.endLineCharacter) && Pattern.compile("(?s)\n").matcher(fileContent).find() || DEFAULT_FORMAT.equals(this.endLineCharacter) && Pattern.compile("(?s)\r").matcher(fileContent).find() || "CRLF".equals(this.endLineCharacter) && Pattern.compile("(?s)(\r(?!\n)|(?<!\r)\n)").matcher(fileContent).find();
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": File " + this.getContext().getFile().getName() + " cannot be read.", e);
        }
    }
}

