/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.Comment;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.CommentLinesVisitor;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.utils.LintyException;
import com.lintyservices.utils.RegexUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="TCL014")
public class FileHeaderTemplateCheck
extends DoubleDispatchVisitorCheck {
    @RuleProperty(key="text", description="Header format as plain text. Format must not contain comment markers.", type="TEXT")
    public String headerTextFormat = "";
    @RuleProperty(key="regex", description="Header format as regular expression. Format must not contain comment markers. Note that each line of the header is trimmed before applying the regular expression. The following placeholders can be used to ease the writing of the regular expression: {EMAIL} and {URL}. They will be replaced with proper regular expressions at runtime. See documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com")
    public String headerRegexFormat = "";
    @RuleProperty(key="path", description="Header format as a relative path to the template file (base directory is SonarQube scanner project directory). Template file must not contain comment markers.")
    public String headerPathFormat = "";

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        String header = this.header(tree);
        if (!header.isBlank()) {
            this.checkAgainstText(header);
            this.checkAgainstRegex(header);
            this.checkAgainstFileTemplate(header);
        }
        super.visitScriptFile(tree);
    }

    @Override
    public void validateCheckParameters() {
        if (!this.properlyFilledInParameters()) {
            throw new LintyException(FileHeaderTemplateCheck.paramsErrorMessage(this.getClass(), "One and only one parameter must be filled in."));
        }
        if (!this.headerRegexFormat.isBlank()) {
            try {
                RegexUtils.processPattern(this.headerRegexFormat);
            }
            catch (PatternSyntaxException exception) {
                throw new LintyException(FileHeaderTemplateCheck.paramsErrorMessage(this.getClass(), "regex parameter \"" + this.headerRegexFormat + "\" is not a valid regular expression."), exception);
            }
        }
    }

    private String header(ScriptFileTree tree) {
        return new CommentLinesVisitor(tree).getComments().stream().filter(Comment::isHeader).map(c -> c.tree().actualText()).collect(Collectors.joining("\n"));
    }

    private void checkAgainstText(String header) {
        String standardizedHeaderTextFormat = this.trim(this.headerTextFormat);
        if (!standardizedHeaderTextFormat.isBlank() && !header.equals(standardizedHeaderTextFormat)) {
            this.addIssue();
        }
    }

    private void checkAgainstRegex(String header) {
        if (!this.headerRegexFormat.isBlank() && !RegexUtils.processPattern(this.headerRegexFormat).matcher(header).matches()) {
            this.addIssue();
        }
    }

    private void checkAgainstFileTemplate(String header) {
        if (!this.headerPathFormat.isBlank()) {
            String templateContent;
            try {
                byte[] rawText = Files.readAllBytes(Paths.get(this.headerPathFormat, new String[0]));
                templateContent = this.trim(new String(rawText, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new LintyException(this.getClass().getAnnotation(Rule.class).key() + " - Cannot read template file", e);
            }
            if (!header.equals(templateContent)) {
                this.addIssue();
            }
        }
    }

    private void addIssue() {
        this.addFileIssue("Update the file header to comply with the expected template.");
    }

    private boolean properlyFilledInParameters() {
        int count = 0;
        if (!this.headerTextFormat.isBlank()) {
            ++count;
        }
        if (!this.headerRegexFormat.isBlank()) {
            ++count;
        }
        if (!this.headerPathFormat.isBlank()) {
            ++count;
        }
        return count == 1;
    }

    private String trim(String text) {
        String textWithProperLineEndings = text.replace("\r\n", "\n").replace("\r", "\n").replaceAll("\\n[ \\t]+", "\n");
        StringBuilder trimmedText = new StringBuilder();
        for (String line : textWithProperLineEndings.split("\n")) {
            trimmedText.append(line.trim()).append("\n");
        }
        return trimmedText.substring(0, trimmedText.length() - 1);
    }
}

