/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="TCL015")
public class FileNamingConventionCheck
extends DoubleDispatchVisitorCheck {
    public static final String DEFAULT_FORMAT = "^[a-z][a-z\\d_]*\\.tcl$";
    @RuleProperty(key="format", description="Regular expression to match: Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^[a-z][a-z\\d_]*\\.tcl$")
    public String format = "^[a-z][a-z\\d_]*\\.tcl$";

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        Pattern pattern = Pattern.compile(this.format, 32);
        if (!pattern.matcher(this.getContext().getFile().getName()).matches()) {
            this.addFileIssue("Rename this file to match the following regular expression: " + this.format);
        }
        super.visitScriptFile(tree);
    }
}

