/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.utils.LintyException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.sonar.check.Rule;

@Rule(key="TCL007")
public class MissingNewLineAtEndOfFileCheck
extends DoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() < 1L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 1L);
        byte[] chars = new byte[1];
        if (randomAccessFile.read(chars) < 1) {
            return false;
        }
        String ch = new String(chars);
        return "\n".equals(ch) || "\r".equals(ch);
    }

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.getContext().getFile(), "r");){
            if (randomAccessFile.length() != 0L && !MissingNewLineAtEndOfFileCheck.endsWithNewline(randomAccessFile)) {
                this.addFileIssue("Add an empty new line at the end of this file.");
            }
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": Error while reading " + this.getContext().getFile().getName(), e);
        }
        super.visitScriptFile(tree);
    }
}

