/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="TCL011")
public class TabCharacterCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor,
FreeHdlDesignerCheck {
    private Charset charset;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        List<String> lines;
        File file = this.getContext().getFile();
        try {
            lines = Files.readLines(file, this.charset);
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": Error while reading " + file.getName(), e);
        }
        for (String line : lines) {
            if (!line.contains("\t")) continue;
            this.addFileIssue("Replace all tab characters in this file by sequences of white-spaces.");
            break;
        }
    }
}

