/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="TCL009")
public class TooLongLineCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor {
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 120;
    @RuleProperty(key="max", description="The maximum authorized line length.", defaultValue="120")
    int max = 120;
    private Charset charset;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        List<String> lines;
        File file = this.getContext().getFile();
        try {
            lines = Files.readLines(file, this.charset);
        }
        catch (IOException e) {
            throw new LintyException("Cannot read file: " + file.getAbsolutePath(), e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.length() <= this.max) continue;
            this.addLineIssue(i + 1, MessageFormat.format("Split this {0} characters long line (which is greater than {1} authorized).", line.length(), this.max));
        }
    }
}

