/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.LinesOfCodeVisitor;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="TCL008")
public class TooManyLinesOfCodeInFileCheck
extends DoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final int DEFAULT_MAXIMUM = 350;
    @RuleProperty(key="max", description="Maximum number of lines of code in a file.", defaultValue="350")
    public int max = 350;

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        int lines = new LinesOfCodeVisitor(tree).getNumberOfLinesOfCode();
        if (lines > this.max) {
            this.addFileIssue(MessageFormat.format("This file has {0} lines of code, which is greater than {1} authorized. Split it into smaller files.", lines, this.max));
        }
        super.visitScriptFile(tree);
    }
}

