/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.LinesOfCodeVisitor;
import com.lintyservices.sonar.plugins.tcl.parser.ProcTree;
import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="TCL022")
public class TooManyLinesOfCodeInProcCheck
extends DoubleDispatchVisitorCheck
implements FreeHdlDesignerCheck {
    private static final int DEFAULT_MAXIMUM = 100;
    @RuleProperty(key="max", description="Maximum number of lines of code in a proc.", defaultValue="100")
    public int max = 100;

    @Override
    public void visitProc(ProcTree tree) {
        int lines;
        if (tree.body().commandsAndTerminators() != null && (lines = new LinesOfCodeVisitor(tree.body().commandsAndTerminators()).getNumberOfLinesOfCode()) > this.max) {
            this.addPreciseIssue(tree.name(), MessageFormat.format("This proc has {0} lines of code, which is greater than {1} authorized. Split it into smaller procs.", lines, this.max));
        }
        super.visitProc(tree);
    }
}

