/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.active;

import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.utils.LintyException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;

@Rule(key="TCL010")
public class TrailingWhitespaceCheck
extends DoubleDispatchVisitorCheck
implements CharsetAwareVisitor,
FreeHdlDesignerCheck {
    private static final String WHITESPACE = "\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}";
    private Charset charset;

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        List<String> lines;
        try {
            lines = Files.readLines(this.getContext().getFile(), this.charset);
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": Error while reading " + this.getContext().getFile().getName(), e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.length() <= 0 || !Pattern.matches("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]", line.subSequence(line.length() - 1, line.length()))) continue;
            this.addLineIssue(i + 1, "Remove the useless trailing whitespaces at the end of this line.");
        }
        super.visitScriptFile(tree);
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

