/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.checks.helpers;

import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitorCheck;
import com.lintyservices.sonar.plugins.tcl.parser.ScriptFileTree;
import com.lintyservices.sonar.plugins.tcl.parser.WithNameTree;
import com.lintyservices.utils.LintyException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class StandardNamingConventionCheck
extends DoubleDispatchVisitorCheck {
    public static final String REGULAR_EXPRESSION_DOCUMENTATION = "See regular expression documentation at https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/regex/Pattern.html";
    public static final String DESCRIPTION = "Regular expression to match. See regular expression documentation at https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/regex/Pattern.html";
    private Pattern pattern;

    @Override
    public void visitScriptFile(ScriptFileTree tree) {
        this.pattern = this.computePattern();
        super.visitScriptFile(tree);
    }

    public void checkForNamingConventionIssue(WithNameTree tree) {
        if (tree.name().name() != null && !this.pattern.matcher(tree.name().name()).matches()) {
            this.addPreciseIssue(tree.name(), "Rename this " + tree.humanReadableKind() + " to match the following regular expression: " + this.getFormat());
        }
    }

    public abstract String getFormat();

    public abstract void setFormat(String var1);

    private Pattern computePattern() {
        return Pattern.compile(this.getFormat(), 32);
    }

    @Override
    public void validateCheckParameters() {
        try {
            Pattern.compile(this.getFormat());
        }
        catch (PatternSyntaxException exception) {
            throw new LintyException(StandardNamingConventionCheck.paramsErrorMessage(this.getClass(), "format parameter \"" + this.getFormat() + "\" is not a valid regular expression."), exception);
        }
    }
}

