/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.measures.visitors;

import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.CommentAnalyzer;
import java.util.HashSet;
import java.util.Set;

public class Comment {
    private static final CommentAnalyzer commentAnalyzer = new CommentAnalyzer();
    private final SyntaxTrivia trivia;
    private final boolean isHeader;
    private final boolean isTrailing;

    public Comment(SyntaxTrivia trivia, boolean isHeader, boolean isTrailing) {
        this.trivia = trivia;
        this.isHeader = isHeader;
        this.isTrailing = isTrailing;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public boolean isTrailing() {
        return this.isTrailing;
    }

    public boolean isBlank() {
        String[] lineContents = this.getLineContents();
        boolean blank = true;
        for (String lineContent : lineContents) {
            if (commentAnalyzer.isBlank(lineContent)) continue;
            blank = false;
            break;
        }
        return blank;
    }

    public Set<Integer> getLineNumbers() {
        String[] lineContents = this.getLineContents();
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        for (int i = this.trivia.line(); i < this.trivia.line() + lineContents.length; ++i) {
            lineNumbers.add(i);
        }
        return lineNumbers;
    }

    public SyntaxTrivia tree() {
        return this.trivia;
    }

    private String[] getLineContents() {
        return commentAnalyzer.getContents(this.trivia.text()).split("(\r)?\n|\r", -1);
    }
}

