/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.measures.visitors;

import com.lintyservices.sonar.plugins.tcl.api.tree.SubscriptionVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.Comment;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.CommentAnalyzer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommentLinesVisitor
extends SubscriptionVisitor {
    private final Set<Integer> commentLines = new HashSet<Integer>();
    private final List<Comment> comments = new ArrayList<Comment>();
    private final CommentAnalyzer commentAnalyzer = new CommentAnalyzer();
    private boolean inHeader = true;
    private int previousTokenLine = -1;
    private int previousCommentLine = 0;

    public CommentLinesVisitor(TclTree tree) {
        this.scanTree(tree);
    }

    public Set<Integer> getCommentLines() {
        return this.commentLines;
    }

    public int getNumberOfCommentLines() {
        return this.commentLines.size();
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    @Override
    public Set<TclTree.Kind> nodesToVisit() {
        return Set.of(TclTree.Kind.TOKEN);
    }

    @Override
    public void visitNode(TclTree tree) {
        SyntaxToken token = (SyntaxToken)tree;
        for (SyntaxTrivia trivia : token.trivias()) {
            if (this.inHeader && trivia.line() - this.previousCommentLine > 1) {
                this.inHeader = false;
            }
            this.comments.add(new Comment(trivia, this.inHeader, trivia.line() == this.previousTokenLine));
            this.previousCommentLine = trivia.line();
            if (this.inHeader) continue;
            this.handleCommentsForTrivia(trivia);
        }
        this.previousTokenLine = token.line();
        this.inHeader = false;
    }

    private void handleCommentsForTrivia(SyntaxTrivia trivia) {
        String[] lineContents = this.commentAnalyzer.getContents(trivia.text()).split("(\r)?\n|\r", -1);
        int lineNumber = trivia.line();
        for (String lineContent : lineContents) {
            if (!this.commentAnalyzer.isBlank(lineContent)) {
                this.commentLines.add(lineNumber);
            }
            ++lineNumber;
        }
    }
}

