/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.measures.visitors;

import com.lintyservices.sonar.plugins.tcl.api.tree.SubscriptionVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.CommentLinesVisitor;
import com.lintyservices.sonar.plugins.tcl.measures.visitors.LinesOfCodeVisitor;
import java.io.Serializable;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;

public class MetricsVisitor
extends SubscriptionVisitor {
    private final SensorContext sensorContext;
    private final FileSystem fileSystem;
    private InputFile inputFile;

    public MetricsVisitor(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
        this.fileSystem = sensorContext.fileSystem();
    }

    @Override
    public Set<TclTree.Kind> nodesToVisit() {
        return Set.of(TclTree.Kind.SCRIPT_FILE);
    }

    @Override
    public void visitFile(TclTree tree) {
        this.inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(this.getContext().getFile()));
    }

    @Override
    public void leaveFile(TclTree tree) {
        this.saveMetricOnFile(CoreMetrics.COMMENT_LINES, new CommentLinesVisitor(this.getContext().getTree()).getNumberOfCommentLines());
        this.saveMetricOnFile(CoreMetrics.NCLOC, new LinesOfCodeVisitor(this.getContext().getTree()).getNumberOfLinesOfCode());
    }

    private <T extends Serializable> void saveMetricOnFile(Metric<T> metric, T value) {
        this.sensorContext.newMeasure().forMetric(metric).on((InputComponent)this.inputFile).withValue(value).save();
    }
}

