/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.model;

import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import java.util.Collections;
import java.util.List;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class InternalSyntaxToken
extends TreeImpl
implements SyntaxToken {
    private final List<SyntaxTrivia> trivias;
    private final int line;
    private final int column;
    private final String value;
    private final boolean isEOF;
    private int endLine;
    private int endColumn;

    public InternalSyntaxToken(int line, int column, String value, List<SyntaxTrivia> trivias, boolean isEOF) {
        super(null);
        this.value = value;
        this.line = line;
        this.column = column;
        this.trivias = trivias;
        this.isEOF = isEOF;
        this.calculateEndOffsets();
    }

    private void calculateEndOffsets() {
        String[] lines = this.value.split("\r\n|\n|\r", -1);
        this.endColumn = this.column + this.value.length();
        this.endLine = this.line + lines.length - 1;
        if (this.endLine != this.line) {
            this.endColumn = lines[lines.length - 1].length();
        }
    }

    @Override
    public SyntaxToken firstToken() {
        return this;
    }

    @Override
    public SyntaxToken lastToken() {
        return this;
    }

    @Override
    public String text() {
        return this.value;
    }

    @Override
    public List<SyntaxTrivia> trivias() {
        return this.trivias;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitSyntaxToken(this);
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public int endLine() {
        return this.endLine;
    }

    @Override
    public int endColumn() {
        return this.endColumn;
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.TOKEN;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    @Override
    public Iterable<TclTree> children() {
        return Collections.emptyList();
    }

    public void setGrammarRuleKey(GrammarRuleKey grammarRuleKey) {
        this.grammarRuleKey = grammarRuleKey;
    }
}

