/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.model;

import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.sslr.grammar.GrammarRuleKey;

public abstract class TreeImpl
implements TclTree {
    @Nullable
    protected GrammarRuleKey grammarRuleKey;
    @Nullable
    private TclTree parent;
    private List<TclTree> children;

    protected TreeImpl(@Nullable GrammarRuleKey grammarRuleKey) {
        this.grammarRuleKey = grammarRuleKey;
    }

    @Override
    @Nullable
    public SyntaxToken firstToken() {
        for (TclTree child : this.getChildren()) {
            SyntaxToken first = child.firstToken();
            if (first == null) continue;
            return first;
        }
        return null;
    }

    @Override
    @Nullable
    public SyntaxToken lastToken() {
        List<TclTree> trees = this.getChildren();
        for (int index = trees.size() - 1; index >= 0; --index) {
            SyntaxToken last = trees.get(index).lastToken();
            if (last == null) continue;
            return last;
        }
        return null;
    }

    @Override
    public int numberOfTokens() {
        return this.allChildren(TclTree.Kind.TOKEN).size();
    }

    @Override
    public int line() {
        SyntaxToken firstSyntaxToken = this.firstToken();
        if (firstSyntaxToken == null) {
            return -1;
        }
        return firstSyntaxToken.line();
    }

    @Override
    public int column() {
        SyntaxToken firstSyntaxToken = this.firstToken();
        if (firstSyntaxToken == null) {
            return -1;
        }
        return firstSyntaxToken.column();
    }

    @Override
    public int endLine() {
        SyntaxToken lastSyntaxToken = this.lastToken();
        if (lastSyntaxToken == null) {
            return -1;
        }
        return lastSyntaxToken.endLine();
    }

    @Override
    public int endColumn() {
        SyntaxToken lastSyntaxToken = this.lastToken();
        if (lastSyntaxToken == null) {
            return -1;
        }
        return lastSyntaxToken.endColumn();
    }

    @Override
    public final boolean isOneOf(TclTree.Kind ... kinds) {
        return this.isOneOf(Set.of(kinds));
    }

    @Override
    public final boolean isOneOf(Set<TclTree.Kind> kinds) {
        return kinds.contains(this.kind());
    }

    @Override
    public final boolean is(TclTree.Kind kind) {
        return this.isOneOf(kind);
    }

    @Override
    public TclTree parent() {
        return this.parent;
    }

    public void setParent(TclTree parent) {
        this.parent = parent;
    }

    @Override
    public boolean hasAncestor(TclTree.Kind kind) {
        if (this.parent() != null) {
            if (this.parent().is(kind)) {
                return true;
            }
            return this.parent().hasAncestor(kind);
        }
        return false;
    }

    @Override
    @Nullable
    public TclTree ancestor(TclTree.Kind kind) {
        if (this.parent() != null) {
            if (this.parent().is(kind)) {
                return this.parent;
            }
            return this.parent().ancestor(kind);
        }
        return null;
    }

    protected abstract Iterable<TclTree> children();

    @Override
    public List<TclTree> allChildren(TclTree.Kind kind) {
        return this.allChildren(Set.of(kind));
    }

    @Override
    public List<TclTree> allChildren(Set<TclTree.Kind> kinds) {
        return this.allChildren(kinds, Set.of());
    }

    @Override
    public List<TclTree> allChildren(Set<TclTree.Kind> kinds, Set<TclTree.Kind> branchesToExclude) {
        ArrayList<TclTree> allChildren = new ArrayList<TclTree>();
        this.allChildren(this, kinds, branchesToExclude, allChildren);
        return allChildren;
    }

    private void allChildren(TreeImpl tree, Set<TclTree.Kind> kinds, Set<TclTree.Kind> branchesToExclude, List<TclTree> allChildren) {
        tree.children().forEach(child -> {
            if (child != null) {
                if (child.isOneOf(kinds)) {
                    allChildren.add((TclTree)child);
                }
                if (!branchesToExclude.contains(child.kind())) {
                    ((TreeImpl)child).allChildren((TreeImpl)child, kinds, branchesToExclude, allChildren);
                }
            }
        });
    }

    public List<TclTree> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<TclTree>();
            this.children().forEach(child -> {
                if (child != null) {
                    this.children.add((TclTree)child);
                }
            });
        }
        return this.children;
    }

    public boolean isLeaf() {
        return false;
    }

    @Nullable
    public GrammarRuleKey getGrammarRuleKey() {
        return this.grammarRuleKey;
    }

    @Override
    public String toString() {
        return this.toString(this, new StringBuilder());
    }

    private String toString(TclTree tree, StringBuilder builder) {
        if (tree.is(TclTree.Kind.TOKEN)) {
            builder.append(tree.firstToken().text().toLowerCase());
        }
        if (!((TreeImpl)tree).isLeaf()) {
            for (TclTree value : ((TreeImpl)tree).getChildren()) {
                TreeImpl nextTree = (TreeImpl)value;
                this.toString(nextTree, builder);
            }
        }
        return String.valueOf(builder);
    }
}

