/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.BracketsBlockTree;
import com.lintyservices.sonar.plugins.tcl.parser.CommandsAndTerminatorsTree;
import java.util.Collections;
import javax.annotation.Nullable;

public class BracketsBlockTreeImpl
extends TreeImpl
implements BracketsBlockTree {
    private final SyntaxToken leftBracket;
    @Nullable
    private final CommandsAndTerminatorsTree commandsAndTerminators;
    private final SyntaxToken rightBracket;

    public BracketsBlockTreeImpl(SyntaxToken leftBracket, @Nullable CommandsAndTerminatorsTree commandsAndTerminators, SyntaxToken rightBracket) {
        super(TclTree.Kind.BRACKET_BLOCK);
        this.leftBracket = leftBracket;
        this.commandsAndTerminators = commandsAndTerminators;
        this.rightBracket = rightBracket;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitBracketsBlock(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.BRACKET_BLOCK;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.leftBracket), this.commandsAndTerminators != null ? Collections.singleton(this.commandsAndTerminators) : Collections.emptyList(), Collections.singleton(this.rightBracket));
    }

    @Override
    public SyntaxToken leftBracket() {
        return this.leftBracket;
    }

    @Override
    @Nullable
    public CommandsAndTerminatorsTree commandsAndTerminators() {
        return this.commandsAndTerminators;
    }

    @Override
    public SyntaxToken rightBracket() {
        return this.rightBracket;
    }
}

