/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.ExprTree;
import java.util.Collections;
import java.util.List;

public class ExprTreeImpl
extends TreeImpl
implements ExprTree {
    private final SyntaxToken exprKeyword;
    private final List<TclTree> arguments;

    public ExprTreeImpl(SyntaxToken exprKeyword, List<TclTree> arguments) {
        super(TclTree.Kind.EXPR);
        this.exprKeyword = exprKeyword;
        this.arguments = arguments;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitExpr(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.EXPR;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.exprKeyword), this.arguments);
    }

    @Override
    public SyntaxToken exprKeyword() {
        return this.exprKeyword;
    }

    @Override
    public List<TclTree> arguments() {
        return this.arguments;
    }
}

