/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.NameTree;
import java.util.Arrays;
import java.util.Collections;

public class NameTreeImpl
extends TreeImpl
implements NameTree {
    private final SyntaxToken identifier;

    public NameTreeImpl(SyntaxToken identifier) {
        super(TclTree.Kind.NAME);
        this.identifier = identifier;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitName(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.NAME;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(new Iterable[]{Collections.singleton(this.identifier)});
    }

    @Override
    public SyntaxToken identifier() {
        return this.identifier;
    }

    @Override
    public String text() {
        return this.identifier.text();
    }

    @Override
    public String name() {
        return Arrays.stream(this.text().split("::")).reduce((first, second) -> second).orElse(null);
    }
}

