/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.CurlyBracesBlockTree;
import com.lintyservices.sonar.plugins.tcl.parser.NameTree;
import com.lintyservices.sonar.plugins.tcl.parser.NamespaceEvalTree;
import java.util.Collections;

public class NamespaceEvalTreeImpl
extends TreeImpl
implements NamespaceEvalTree {
    private final SyntaxToken namespaceKeyword;
    private final SyntaxToken evalKeyword;
    private final NameTree name;
    private final CurlyBracesBlockTree body;

    public NamespaceEvalTreeImpl(SyntaxToken namespaceKeyword, SyntaxToken evalKeyword, NameTree name, CurlyBracesBlockTree body) {
        super(TclTree.Kind.NAMESPACE_EVAL);
        this.namespaceKeyword = namespaceKeyword;
        this.evalKeyword = evalKeyword;
        this.name = name;
        this.body = body;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitNamespaceEval(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.NAMESPACE_EVAL;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.namespaceKeyword), Collections.singleton(this.evalKeyword), Collections.singleton(this.name), Collections.singleton(this.body));
    }

    @Override
    public SyntaxToken namespaceKeyword() {
        return this.namespaceKeyword;
    }

    @Override
    public SyntaxToken evalKeyword() {
        return this.evalKeyword;
    }

    @Override
    public NameTree name() {
        return this.name;
    }

    @Override
    public CurlyBracesBlockTree body() {
        return this.body;
    }

    @Override
    public String humanReadableKind() {
        return "namespace";
    }
}

