/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.NameTree;
import com.lintyservices.sonar.plugins.tcl.parser.PackageProvideTree;
import java.util.Collections;
import java.util.List;

public class PackageProvideTreeImpl
extends TreeImpl
implements PackageProvideTree {
    private final SyntaxToken packageKeyword;
    private final SyntaxToken provideKeyword;
    private final NameTree name;
    private final List<TclTree> arguments;

    public PackageProvideTreeImpl(SyntaxToken packageKeyword, SyntaxToken provideKeyword, NameTree name, List<TclTree> arguments) {
        super(TclTree.Kind.PACKAGE_PROVIDE);
        this.packageKeyword = packageKeyword;
        this.provideKeyword = provideKeyword;
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitPackageProvide(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.PACKAGE_PROVIDE;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.packageKeyword), Collections.singleton(this.provideKeyword), Collections.singleton(this.name), this.arguments);
    }

    @Override
    public SyntaxToken packageKeyword() {
        return this.packageKeyword;
    }

    @Override
    public SyntaxToken provideKeyword() {
        return this.provideKeyword;
    }

    @Override
    public NameTree name() {
        return this.name;
    }

    @Override
    public List<TclTree> arguments() {
        return this.arguments;
    }

    @Override
    public String humanReadableKind() {
        return "package";
    }
}

