/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.CommandsAndTerminatorsTree;
import com.lintyservices.sonar.plugins.tcl.parser.ParenthesesBlockTree;
import java.util.Collections;
import javax.annotation.Nullable;

public class ParenthesesBlockTreeImpl
extends TreeImpl
implements ParenthesesBlockTree {
    private final SyntaxToken leftParenthesis;
    @Nullable
    private final CommandsAndTerminatorsTree commandsAndTerminators;
    private final SyntaxToken rightParenthesis;

    public ParenthesesBlockTreeImpl(SyntaxToken leftParenthesis, @Nullable CommandsAndTerminatorsTree commandsAndTerminators, SyntaxToken rightParenthesis) {
        super(TclTree.Kind.PARENTHESIS_BLOCK);
        this.leftParenthesis = leftParenthesis;
        this.commandsAndTerminators = commandsAndTerminators;
        this.rightParenthesis = rightParenthesis;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitParenthesesBlock(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.PARENTHESIS_BLOCK;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.leftParenthesis), this.commandsAndTerminators != null ? Collections.singleton(this.commandsAndTerminators) : Collections.emptyList(), Collections.singleton(this.rightParenthesis));
    }

    @Override
    public SyntaxToken leftParenthesis() {
        return this.leftParenthesis;
    }

    @Override
    @Nullable
    public CommandsAndTerminatorsTree commandsAndTerminators() {
        return this.commandsAndTerminators;
    }

    @Override
    public SyntaxToken rightParenthesis() {
        return this.rightParenthesis;
    }
}

