/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.CurlyBracesBlockTree;
import com.lintyservices.sonar.plugins.tcl.parser.NameTree;
import com.lintyservices.sonar.plugins.tcl.parser.ProcTree;
import java.util.Collections;

public class ProcTreeImpl
extends TreeImpl
implements ProcTree {
    private final SyntaxToken procKeyword;
    private final NameTree name;
    private final TclTree arguments;
    private final CurlyBracesBlockTree body;

    public ProcTreeImpl(SyntaxToken procKeyword, NameTree name, TclTree arguments, CurlyBracesBlockTree body) {
        super(TclTree.Kind.PROC);
        this.procKeyword = procKeyword;
        this.name = name;
        this.arguments = arguments;
        this.body = body;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitProc(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.PROC;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.procKeyword), Collections.singleton(this.name), Collections.singleton(this.arguments), Collections.singleton(this.body));
    }

    @Override
    public SyntaxToken procKeyword() {
        return this.procKeyword;
    }

    @Override
    public NameTree name() {
        return this.name;
    }

    @Override
    public TclTree arguments() {
        return this.arguments;
    }

    @Override
    public CurlyBracesBlockTree body() {
        return this.body;
    }

    @Override
    public String humanReadableKind() {
        return "proc";
    }
}

