/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.RegexpTree;
import java.util.Collections;
import java.util.List;

public class RegexpTreeImpl
extends TreeImpl
implements RegexpTree {
    private final SyntaxToken regexpKeyword;
    private final List<TclTree> arguments;

    public RegexpTreeImpl(SyntaxToken regexpKeyword, List<TclTree> arguments) {
        super(TclTree.Kind.REGEXP);
        this.regexpKeyword = regexpKeyword;
        this.arguments = arguments;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitRegexp(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.REGEXP;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.regexpKeyword), this.arguments);
    }

    @Override
    public SyntaxToken regexpKeyword() {
        return this.regexpKeyword;
    }

    @Override
    public List<TclTree> arguments() {
        return this.arguments;
    }
}

