/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.NameTree;
import com.lintyservices.sonar.plugins.tcl.parser.SetTree;
import java.util.Collections;
import java.util.List;

public class SetTreeImpl
extends TreeImpl
implements SetTree {
    private final SyntaxToken setKeyword;
    private final NameTree name;
    private final List<TclTree> arguments;

    public SetTreeImpl(SyntaxToken setKeyword, NameTree name, List<TclTree> arguments) {
        super(TclTree.Kind.SET);
        this.setKeyword = setKeyword;
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitSet(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.SET;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.setKeyword), Collections.singleton(this.name), this.arguments);
    }

    @Override
    public SyntaxToken setKeyword() {
        return this.setKeyword;
    }

    @Override
    public NameTree name() {
        return this.name;
    }

    @Override
    public List<TclTree> arguments() {
        return this.arguments;
    }

    @Override
    public String humanReadableKind() {
        return "variable";
    }
}

