/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.StringTree;
import java.util.Collections;
import java.util.List;

public class StringTreeImpl
extends TreeImpl
implements StringTree {
    private final SyntaxToken leftQuote;
    private final List<TclTree> elements;
    private final SyntaxToken rightQuote;

    public StringTreeImpl(SyntaxToken leftQuote, List<TclTree> elements, SyntaxToken rightQuote) {
        super(TclTree.Kind.STRING);
        this.leftQuote = leftQuote;
        this.elements = elements;
        this.rightQuote = rightQuote;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitString(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.STRING;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.leftQuote), this.elements, Collections.singleton(this.rightQuote));
    }

    @Override
    public SyntaxToken leftQuote() {
        return this.leftQuote;
    }

    @Override
    public List<TclTree> elements() {
        return this.elements;
    }

    @Override
    public SyntaxToken rightQuote() {
        return this.rightQuote;
    }
}

