/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.lintyservices.sonar.plugins.tcl.lexer.TclKeyword;
import com.lintyservices.sonar.plugins.tcl.lexer.TclPunctuator;
import com.lintyservices.sonar.plugins.tcl.lexer.TclTokenType;
import com.sonar.sslr.api.GenericTokenType;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum TclLexer implements GrammarRuleKey
{
    BRACKETS_BLOCK,
    COMMAND,
    COMMAND_ELEMENTS_FOR_BLOCK,
    COMMAND_ELEMENTS_FOR_REGEXP,
    COMMAND_ELEMENTS_FOR_STRING,
    COMMANDS_AND_TERMINATORS,
    COMMENT,
    COMMON_COMMAND_ELEMENT,
    CURLY_BRACES_BLOCK,
    EOF,
    EXPR,
    IDENTIFIER,
    LETTER_OR_DIGIT,
    NAME,
    NAMESPACE_EVAL,
    PACKAGE_PROVIDE,
    PARENTHESES_BLOCK,
    PROC,
    PUTS,
    REGEXP,
    REGSUB,
    REGEXP_EXPRESSION,
    SCRIPT_FILE,
    SET,
    SPACING,
    SPACING_WITHOUT_LINE_ENDINGS,
    STRING,
    TERMINATOR,
    UNKNOWN_COMMAND,
    VARIABLE,
    VARIABLE_INTERPOLATION;


    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        TclLexer.punctuators(b);
        TclLexer.keywords(b);
        TclLexer.literals(b);
        b.setRootRule(SCRIPT_FILE);
        return b;
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        for (TclKeyword keyword : TclKeyword.values()) {
            b.rule(keyword).is(b.regexp(keyword.getValue()), b.nextNot(LETTER_OR_DIGIT), SPACING_WITHOUT_LINE_ENDINGS);
        }
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        TclLexer.punctuatorSpaceWithoutLineEndings(b, TclPunctuator.DOUBLE_QUOTE, TclPunctuator.DOUBLE_QUOTE.getValue());
        TclLexer.punctuatorSpaceWithoutLineEndings(b, TclPunctuator.LEFT_BRACKET, TclPunctuator.LEFT_BRACKET.getValue());
        TclLexer.punctuatorSpaceWithoutLineEndings(b, TclPunctuator.LEFT_PARENTHESIS, TclPunctuator.LEFT_PARENTHESIS.getValue());
        TclLexer.punctuatorSpaceWithoutLineEndings(b, TclPunctuator.RIGHT_BRACKET, TclPunctuator.RIGHT_BRACKET.getValue());
        TclLexer.punctuatorSpaceWithoutLineEndings(b, TclPunctuator.RIGHT_CURLY_BRACE, TclPunctuator.RIGHT_CURLY_BRACE.getValue());
        TclLexer.punctuatorSpaceWithoutLineEndings(b, TclPunctuator.RIGHT_PARENTHESIS, TclPunctuator.RIGHT_PARENTHESIS.getValue());
        TclLexer.punctuator(b, TclPunctuator.LEFT_CURLY_BRACE, TclPunctuator.LEFT_CURLY_BRACE.getValue());
        TclLexer.punctuator(b, TclPunctuator.SEMICOLON, TclPunctuator.SEMICOLON.getValue());
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        b.rule(ruleKey).is(value, SPACING);
    }

    private static void punctuatorSpaceWithoutLineEndings(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        b.rule(ruleKey).is(value, SPACING_WITHOUT_LINE_ENDINGS);
    }

    private static void literals(LexerlessGrammarBuilder b) {
        String newLine = "(\\n|\\r\\n|\\r)";
        b.rule(SPACING_WITHOUT_LINE_ENDINGS).is(b.skippedTrivia(b.regexp("((\\p{Blank})|(\\\\(?=" + newLine + ")" + newLine + "))*+")));
        b.rule(SPACING).is(b.skippedTrivia(b.regexp("((\\s)|(\\\\(?=" + newLine + ")" + newLine + "))*+")));
        b.rule(COMMENT).is(b.commentTrivia(b.regexp("#[^\\n\\r]*+")), SPACING);
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput()));
        b.rule(LETTER_OR_DIGIT).is(b.regexp("[-_A-Za-z0-9]+"), SPACING_WITHOUT_LINE_ENDINGS);
        String allKeywords = Arrays.stream(TclKeyword.values()).map(TclKeyword::getValue).collect(Collectors.joining("\\b|"));
        b.rule(TclTokenType.IDENTIFIER).is(b.regexp("(?!" + allKeywords + "\\b)([a-zA-Z_\\d:]+)"), SPACING_WITHOUT_LINE_ENDINGS);
        b.rule(TclTokenType.ANY_OTHER_CHARACTERS).is(b.regexp("((?<=\\\\)[\\}\\{\\)\\(\\]\\[;]|[^\\s\\}\\{\\)\\(\\]\\[;])+"), SPACING_WITHOUT_LINE_ENDINGS);
        b.rule(REGEXP_EXPRESSION).is(b.regexp("\\{[^\\s]*\\}(?=\\s)"), SPACING_WITHOUT_LINE_ENDINGS);
        b.rule(TclTokenType.ANY_CHARACTERS_FOR_STRING).is(b.regexp("(((?<=\\\\)\")|[^\\s\"])+"), SPACING_WITHOUT_LINE_ENDINGS);
        b.rule(TclTokenType.KEYWORD).is(b.regexp(allKeywords), SPACING_WITHOUT_LINE_ENDINGS);
        b.rule(TclTokenType.LINE_ENDING_COMMAND_TERMINATOR).is(b.regexp(newLine), SPACING);
        b.rule(TclTokenType.VARIABLE_INTERPOLATION).is(b.regexp("\\$[-_A-Za-z0-9]+"), SPACING_WITHOUT_LINE_ENDINGS);
    }
}

