/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.annotations.VisibleForTesting;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.TclGrammar;
import com.lintyservices.sonar.plugins.tcl.parser.TclLexer;
import com.lintyservices.sonar.plugins.tcl.parser.TclNodeBuilder;
import com.lintyservices.sonar.plugins.tcl.parser.TreeFactory;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.nio.charset.Charset;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class TclParser
extends ActionParser<TclTree> {
    public TclParser(Charset charset) {
        super(charset, TclLexer.createGrammarBuilder(), TclGrammar.class, new TreeFactory(), new TclNodeBuilder(), TclLexer.SCRIPT_FILE);
    }

    @VisibleForTesting
    public TclParser(Charset charset, GrammarRuleKey rootRuleKey) {
        super(charset, TclLexer.createGrammarBuilder(), TclGrammar.class, new TreeFactory(), new TclNodeBuilder(), rootRuleKey);
    }

    public static ActionParser<TclTree> createParser(Charset charset) {
        return new TclParser(charset);
    }

    private static TclTree createParentLink(TreeImpl parent) {
        if (!parent.isLeaf()) {
            for (TclTree nextTree : parent.getChildren()) {
                TreeImpl next = (TreeImpl)nextTree;
                if (next == null) continue;
                next.setParent(parent);
                TclParser.createParentLink(next);
            }
        }
        return parent;
    }

    @Override
    public TclTree parse(File file) {
        return TclParser.createParentLink((TreeImpl)super.parse(file));
    }

    @Override
    public TclTree parse(String source2) {
        return TclParser.createParentLink((TreeImpl)super.parse(source2));
    }
}

