/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.lexer.TclPunctuator;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.TerminatorTree;
import java.util.Collections;

public class TerminatorTreeImpl
extends TreeImpl
implements TerminatorTree {
    private final SyntaxToken terminator;

    public TerminatorTreeImpl(SyntaxToken terminator) {
        super(TclTree.Kind.TERMINATOR);
        this.terminator = terminator;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitTerminator(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.TERMINATOR;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(new Iterable[]{Collections.singleton(this.terminator)});
    }

    @Override
    public SyntaxToken terminator() {
        return this.terminator;
    }

    @Override
    public boolean isSemicolon() {
        return this.terminator.text().equals(TclPunctuator.SEMICOLON.getValue());
    }

    @Override
    public boolean isLineEnding() {
        return !this.isSemicolon();
    }
}

