/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.tcl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.TreeImpl;
import com.lintyservices.sonar.plugins.tcl.parser.NameTree;
import com.lintyservices.sonar.plugins.tcl.parser.VariableTree;
import java.util.Collections;
import java.util.List;

public class VariableTreeImpl
extends TreeImpl
implements VariableTree {
    private final SyntaxToken variableKeyword;
    private final NameTree name;
    private final List<TclTree> arguments;

    public VariableTreeImpl(SyntaxToken variableKeyword, NameTree name, List<TclTree> arguments) {
        super(TclTree.Kind.VARIABLE);
        this.variableKeyword = variableKeyword;
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitVariable(this);
    }

    @Override
    public TclTree.Kind kind() {
        return TclTree.Kind.VARIABLE;
    }

    @Override
    protected Iterable<TclTree> children() {
        return Iterables.concat(Collections.singleton(this.variableKeyword), Collections.singleton(this.name), this.arguments);
    }

    @Override
    public SyntaxToken variableKeyword() {
        return this.variableKeyword;
    }

    @Override
    public NameTree name() {
        return this.name;
    }

    @Override
    public List<TclTree> arguments() {
        return this.arguments;
    }

    @Override
    public String humanReadableKind() {
        return "namespace variable";
    }
}

