/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.visitors;

import com.lintyservices.sonar.plugins.tcl.api.tree.SubscriptionVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.model.InternalSyntaxToken;
import com.lintyservices.sonar.plugins.tcl.parser.TclLexer;
import java.io.File;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;

public class CpdVisitor
extends SubscriptionVisitor {
    private final SensorContext sensorContext;
    private final FileSystem fileSystem;
    private InputFile inputFile;
    private NewCpdTokens cpdTokens;

    public CpdVisitor(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
        this.fileSystem = sensorContext.fileSystem();
    }

    @Override
    public Set<TclTree.Kind> nodesToVisit() {
        return Set.of(TclTree.Kind.TOKEN);
    }

    @Override
    public void visitFile(TclTree tree) {
        File file = this.getContext().getFile();
        this.inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(file));
        this.cpdTokens = this.sensorContext.newCpdTokens().onFile(this.inputFile);
    }

    @Override
    public void leaveFile(TclTree scriptTree) {
        this.cpdTokens.save();
    }

    @Override
    public void visitNode(TclTree tree) {
        InternalSyntaxToken token = (InternalSyntaxToken)tree;
        if (token.getGrammarRuleKey() == TclLexer.EOF) {
            return;
        }
        TextRange range = this.inputFile.newRange(token.line(), token.column(), token.endLine(), token.endColumn());
        this.cpdTokens.addToken(range, token.text());
    }
}

