/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.tcl.visitors;

import com.lintyservices.sonar.plugins.tcl.api.tree.SubscriptionVisitor;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxToken;
import com.lintyservices.sonar.plugins.tcl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.tcl.api.tree.TclTree;
import com.lintyservices.sonar.plugins.tcl.lexer.TclKeyword;
import com.lintyservices.sonar.plugins.tcl.model.InternalSyntaxToken;
import com.lintyservices.sonar.plugins.tcl.parser.NameTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;

public class SyntaxHighlighterVisitor
extends SubscriptionVisitor {
    private static final Set<String> TCL_KEYWORDS = Arrays.stream(TclKeyword.values()).map(TclKeyword::getValue).collect(Collectors.toSet());
    private final SensorContext sensorContext;
    private final FileSystem fileSystem;
    private NewHighlighting highlighting;

    public SyntaxHighlighterVisitor(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
        this.fileSystem = sensorContext.fileSystem();
    }

    @Override
    public Set<TclTree.Kind> nodesToVisit() {
        return Set.of(TclTree.Kind.TOKEN, TclTree.Kind.NAME);
    }

    @Override
    public void visitFile(TclTree tree) {
        this.highlighting = this.sensorContext.newHighlighting().onFile(this.fileSystem.inputFile(this.fileSystem.predicates().is(this.getContext().getFile())));
    }

    @Override
    public void leaveFile(TclTree scriptTree) {
        this.highlighting.save();
    }

    @Override
    public void visitNode(TclTree tree) {
        ArrayList<SyntaxToken> tokens = new ArrayList<SyntaxToken>();
        TypeOfText code = null;
        if (tree.is(TclTree.Kind.TOKEN) && !tree.hasAncestor(TclTree.Kind.STRING)) {
            if (TCL_KEYWORDS.contains(((SyntaxToken)tree).text())) {
                code = TypeOfText.KEYWORD_LIGHT;
                tokens.add((SyntaxToken)tree);
            }
            this.highlightComments((InternalSyntaxToken)tree);
        }
        if (tree.is(TclTree.Kind.NAME)) {
            code = TypeOfText.STRING;
            tokens.add(((NameTree)tree).identifier());
        }
        for (SyntaxToken token : tokens) {
            this.highlight(token, code);
        }
    }

    protected void highlight(SyntaxToken token, TypeOfText type) {
        this.highlighting.highlight(token.line(), token.column(), token.endLine(), token.endColumn(), type);
    }

    private void highlightComments(SyntaxToken token) {
        for (SyntaxTrivia trivia : token.trivias()) {
            this.highlight(trivia, TypeOfText.COMMENT);
        }
    }
}

