/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.emails;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.DeleteRequest;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;
import org.sonarqube.ws.client.emails.WsEmailConfiguration;

public class EmailConfigurationService
extends BaseService {
    private static final String EMAIL_CONFIGURATION_ID = "email-configuration";

    public EmailConfigurationService(WsConnector wsConnector) {
        super(wsConnector, "api/v2/system/email-configurations");
    }

    public String createEmailConfiguration(WsEmailConfiguration config) {
        String body = String.format("{\n  \"host\": \"%s\",\n  \"port\": \"%s\",\n  \"securityProtocol\": \"%s\",\n  \"fromAddress\": \"%s\",\n  \"fromName\": \"%s\",\n  \"subjectPrefix\": \"%s\",\n  \"authMethod\": \"%s\",\n  \"username\": \"%s\",\n  \"basicPassword\": \"%s\",\n  \"oauthAuthenticationHost\": \"%s\",\n  \"oauthClientId\": \"%s\",\n  \"oauthClientSecret\": \"%s\",\n  \"oauthTenant\": \"%s\"\n}\n", config.host(), config.port(), config.securityProtocol(), config.fromAddress(), config.fromName(), config.subjectPrefix(), config.authMethod(), config.username(), config.basicPassword(), config.oauthAuthenticationHost(), config.oauthClientId(), config.oauthClientSecret(), config.oauthTenant());
        WsResponse response = this.call((WsRequest)new PostRequest(this.path()).setBody(body));
        return new Gson().fromJson(response.content(), JsonObject.class).get("id").getAsString();
    }

    public void deleteEmailConfiguration() {
        block2: {
            try {
                this.call(new DeleteRequest(this.path() + "/email-configuration"));
            }
            catch (HttpException e) {
                if (e.code() == 404) break block2;
                throw e;
            }
        }
    }
}

